float4x4 World : WORLD;
float4x4 View;
float4x4 Projection;
float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
texture Texture;

sampler TextureSampler = sampler_state
{
	texture = <Texture>;
	magfilter = LINEAR;
	minfilter = LINEAR;
	mipfilter = LINEAR;
	AddressU = mirror;
	AddressV = mirror;
};

struct VertexInput
{
	float4 Position : POSITION;
	float2 TexCoord : TEXCOORD0;
};

struct VertexOutput
{
	float4 Position : POSITION;
	float2 TexCoord : TEXCOORD0;
};

VertexOutput vertexShader(VertexInput input)
{
	VertexOutput output;
	WorldViewProjection = mul(mul(World, View), Projection);
	output.Position = mul(input.Position, WorldViewProjection);
	output.TexCoord = input.TexCoord;
	return( output );
}

struct PixelInput
{
	float2 TexCoord : TEXCOORD0;
};

float4 pixelShader(PixelInput input) : COLOR
{
	float4 color = tex2D( TextureSampler, input.TexCoord);
	color.rgb = dot(color.rgb, float3(0.3, 0.59, 0.11));
	return( color );
}

technique Default
{
	pass P0
	{
		VertexShader = compile vs_1_1 vertexShader();
		PixelShader = compile ps_2_0 pixelShader();
	}
}